---@meta

---@class FAccelByteQrOptions
---@field logo UTexture2D
---@field EnlargeLogo boolean
---@field LogoRatio float
---@field TextureSize int32
local FAccelByteQrOptions = {}



---@class FGPPBrush
---@field StateFlags EGPPBtnStateFlags
---@field LayoutStyleBrush FGPPWidgetLayoutStyleBrush
local FGPPBrush = {}



---@class FGPPColor
---@field StateFlags EGPPBtnStateFlags
---@field Color FSlateColor
local FGPPColor = {}



---@class FGPPFont
---@field StateFlags EGPPBtnStateFlags
---@field Font FSlateFontInfo
local FGPPFont = {}



---@class FGPPKeyGuideInfo
---@field ExecType EGPPWidgetInputExecType
---@field GuideText FText
---@field bUseFixedKey boolean
---@field FixedKey FKey
local FGPPKeyGuideInfo = {}



---@class FGPPKeyGuideInputInfo
---@field ExecType EGPPWidgetInputExecType
---@field InputKey FKey
local FGPPKeyGuideInputInfo = {}



---@class FGPPKeyImages
---@field DefaultImage FSlateBrush
---@field ImageList TMap<EGPPOSType, FSlateBrush>
local FGPPKeyImages = {}



---@class FGPPPlatformLoginTypeInfo
---@field LoginType EGPPlatformLoginType
---@field DisplayText FText
---@field Brush FSlateBrush
local FGPPPlatformLoginTypeInfo = {}



---@class FGPPWidgetInputConditionExec
---@field Condition UGPPWidgetInputCondition
---@field ExecInfoList TArray<UGPPWidgetInputExecInfo>
local FGPPWidgetInputConditionExec = {}



---@class FGPPWidgetLayoutStyleBrush
---@field WidgetLayoutStyle EGPPWidgetLayoutStyle
---@field Brush FSlateBrush
local FGPPWidgetLayoutStyleBrush = {}



---@class FPaddingByUIMode
---@field Mode EGPPUIMode
---@field Padding FMargin
local FPaddingByUIMode = {}



---@class FSurveyEvent_NoNameEncryption
---@field Title FString
---@field Reward FSurveyReward_NoNameEncryption
---@field URL FString
---@field Active boolean
local FSurveyEvent_NoNameEncryption = {}



---@class FSurveyMessages_NoNameEncryption
---@field Title FString
---@field Description FString
local FSurveyMessages_NoNameEncryption = {}



---@class FSurveyNormal_NoNameEncryption
---@field ID FString
---@field URL FString
---@field defaultLanguage FString
---@field Messages TMap<FString, FSurveyMessages_NoNameEncryption>
---@field StartDate FString
---@field endDate FString
---@field Reward FSurveyReward_NoNameEncryption
local FSurveyNormal_NoNameEncryption = {}



---@class FSurveyReward_NoNameEncryption
---@field ID FString
---@field Quantity int32
local FSurveyReward_NoNameEncryption = {}



---@class IGPPAlertWidgetInterface : IInterface
local IGPPAlertWidgetInterface = {}


---@class IGPPLegalAgreementWidgetInterface : IInterface
local IGPPLegalAgreementWidgetInterface = {}


---@class IGPPLinkKIDByGPGSWidgetInterface : IInterface
local IGPPLinkKIDByGPGSWidgetInterface = {}


---@class IGPPMaintenanceWidgetInterface : IInterface
local IGPPMaintenanceWidgetInterface = {}


---@class IGPPPendingAlertWidgetInterface : IInterface
local IGPPPendingAlertWidgetInterface = {}


---@class IGPPPendingLoginCompleteWidgetInterface : IInterface
local IGPPPendingLoginCompleteWidgetInterface = {}


---@class IGPPPlatformLoginWidgetInterface : IInterface
local IGPPPlatformLoginWidgetInterface = {}


---@class IGPPPurchaseLimitWidgetInterface : IInterface
local IGPPPurchaseLimitWidgetInterface = {}


---@class IGPPToastMessageWidgetInterface : IInterface
local IGPPToastMessageWidgetInterface = {}


---@class IGPPWidgetInterface_Exec_AcceptAllAndStart : IInterface
local IGPPWidgetInterface_Exec_AcceptAllAndStart = {}


---@class IGPPWidgetInterface_Exec_Cancel : IInterface
local IGPPWidgetInterface_Exec_Cancel = {}


---@class IGPPWidgetInterface_Exec_Close : IInterface
local IGPPWidgetInterface_Exec_Close = {}


---@class IGPPWidgetInterface_Exec_OpenDetail : IInterface
local IGPPWidgetInterface_Exec_OpenDetail = {}


---@class IGPPWidgetInterface_Exec_OpenWebBrowser : IInterface
local IGPPWidgetInterface_Exec_OpenWebBrowser = {}


---@class IGPPWidgetInterface_Exec_ScrollMove : IInterface
local IGPPWidgetInterface_Exec_ScrollMove = {}


---@class IGPPWidgetInterface_Exec_Select : IInterface
local IGPPWidgetInterface_Exec_Select = {}


---@class IGPPWidgetInterface_Exec_Start : IInterface
local IGPPWidgetInterface_Exec_Start = {}


---@class UAccelByteQrImage : UWidget
---@field QrText FString
---@field QrOptions FAccelByteQrOptions
---@field CurrentTextureDynamic UTexture2DDynamic
---@field CurrentLogo UTexture2D
local UAccelByteQrImage = {}

---@param Text FString
function UAccelByteQrImage:SetQrText(Text) end
---@param logo UTexture2D
function UAccelByteQrImage:SetQrLogo(logo) end
---@param MaxTexSize int32
---@param Text FString
---@param Options FAccelByteQrOptions
---@return UTexture2DDynamic
function UAccelByteQrImage:GenerateQrTexture2DDynamic(MaxTexSize, Text, Options) end


---@class UGPPAlertWidget : UGPPBaseScreen
---@field T_Title UTextBlock
---@field DescContentRoot UWidget
---@field T_Desc_Content UTextBlock
---@field WS_BtnContent UWidgetSwitcher
---@field Btn_ForOneBtnType UGPPMenuBtnWidget
---@field Btn_1_ForTwoBtnType UGPPMenuBtnWidget
---@field Btn_2_ForTwoBtnType UGPPMenuBtnWidget
---@field TitleText FText
---@field DescriptionContentText FText
---@field LeftBtnText FText
---@field RightBtnText FText
---@field AlertWidgetObject UGPPAlertWidgetObject
local UGPPAlertWidget = {}

---@param bEnable boolean
function UGPPAlertWidget:OnClickBtn_Btn_ForOneBtnType(bEnable) end
---@param bEnable boolean
function UGPPAlertWidget:OnClickBtn_2_ForTwoBtnType(bEnable) end
---@param bEnable boolean
function UGPPAlertWidget:OnClickBtn_1_ForTwoBtnType(bEnable) end


---@class UGPPAlertWidgetObject : UGPPWidgetObject
local UGPPAlertWidgetObject = {}


---@class UGPPAnalyticsSubsystem : UEngineSubsystem
local UGPPAnalyticsSubsystem = {}


---@class UGPPBalloonWidget : UGPPBaseScreen
---@field T_Title UTextBlock
---@field T_Content UTextBlock
local UGPPBalloonWidget = {}



---@class UGPPBaseBtnWidget : UGPPBaseScreen
---@field OnClickedDelegate FGPPBaseBtnWidgetOnClickedDelegate
---@field OnUpdateWidgetDelegate FGPPBaseBtnWidgetOnUpdateWidgetDelegate
---@field Btn_Button UGPPButton
---@field BtnBrush FSlateBrush
---@field CurStateFlags EGPPBtnStateFlags
---@field bNeedFocusForKeyInteraction boolean
---@field KeyBindingList TArray<FKey>
---@field MinimumClickRepetitionTime float
local UGPPBaseBtnWidget = {}

function UGPPBaseBtnWidget:UnlockClick() end
function UGPPBaseBtnWidget:OnUpdateWidget__DelegateSignature() end
function UGPPBaseBtnWidget:OnUnHovered() end
---@param bSelected boolean
function UGPPBaseBtnWidget:OnSelectGPPMenuBtn__DelegateSignature(bSelected) end
function UGPPBaseBtnWidget:OnReleased() end
function UGPPBaseBtnWidget:OnPressed() end
function UGPPBaseBtnWidget:OnHovered() end
---@param Selected boolean
function UGPPBaseBtnWidget:OnClickedGPPMenuBtn__DelegateSignature(Selected) end
function UGPPBaseBtnWidget:OnClicked() end
---@return boolean
function UGPPBaseBtnWidget:GetEnable() end


---@class UGPPBaseScreen : UUserWidget
---@field bUpdateOnPreConstruct boolean
---@field UIMode EGPPUIMode
local UGPPBaseScreen = {}

function UGPPBaseScreen:UpdateWidget() end
function UGPPBaseScreen:OnChangeScreenOrientation() end
---@return EGPPUIMode
function UGPPBaseScreen:GetUIMode() end


---@class UGPPButton : UButton
local UGPPButton = {}


---@class UGPPCountdownTimer : UGPPBaseScreen
---@field Img_ProgressBar UImage
---@field T_Countdown UTextBlock
---@field Timeout float
---@field ProgressBarMaterial UMaterialInterface
---@field ProgressBarColor FColor
---@field OnTimerComplete FGPPCountdownTimerOnTimerComplete
---@field DynProgressBarMaterialIns UMaterialInstanceDynamic
local UGPPCountdownTimer = {}

function UGPPCountdownTimer:StopTimer() end
function UGPPCountdownTimer:StartTimer() end
---@param InEndTime FDateTime
function UGPPCountdownTimer:StartCountdownUntil(InEndTime) end
---@param InTimeout float
function UGPPCountdownTimer:SetTimeout(InTimeout) end
function UGPPCountdownTimer:ResumeTimer() end
function UGPPCountdownTimer:PauseTimer() end
function UGPPCountdownTimer:OnTimerCompleteEvent__DelegateSignature() end
---@return boolean
function UGPPCountdownTimer:IsRunning() end
---@return boolean
function UGPPCountdownTimer:IsPaused() end


---@class UGPPDebugRegionLanguageWidget : UGPPBaseScreen
---@field T_LanInfo_Via_UE UTextBlock
---@field T_LanInfo_Via_OS UTextBlock
---@field T_LanInfo_Via_UserAccount UTextBlock
---@field T_LanInfo_Via_StorePlatformGameSetting UTextBlock
---@field T_RegionInfo_Via_UE UTextBlock
---@field T_RegionInfo_Via_OS UTextBlock
---@field T_RegionInfo_Via_UserAccount UTextBlock
---@field T_RegionInfo_Via_StorePlatformGameSetting UTextBlock
local UGPPDebugRegionLanguageWidget = {}



---@class UGPPFrameAnimationWidget : UUserWidget
---@field Img_Frame UImage
---@field FrameImageList TArray<UTexture2D>
---@field SecondsForFrame float
local UGPPFrameAnimationWidget = {}



---@class UGPPHeaderTabWidget : UGPPBaseScreen
---@field Text FText
---@field GPPMenuBtnWidget UGPPMenuBtnWidget
---@field Img_Select UImage
local UGPPHeaderTabWidget = {}

---@param bSelected boolean
function UGPPHeaderTabWidget:OnClicked_GPPMenuBtnWidget(bSelected) end


---@class UGPPIdentityDuplicateLoginWidget : UGPPBaseScreen
local UGPPIdentityDuplicateLoginWidget = {}

function UGPPIdentityDuplicateLoginWidget:GPPShowDuplicateLoginWidgetBP() end


---@class UGPPIdentityGuestStartWidget : UGPPBaseScreen
local UGPPIdentityGuestStartWidget = {}

---@param pSelectButton EGPPSelectButtonType
function UGPPIdentityGuestStartWidget:OnSelectButton(pSelectButton) end
function UGPPIdentityGuestStartWidget:GPPShowGuestStartWidgetBP() end


---@class UGPPIdentitySelectPlatformWidget : UGPPBaseScreen
local UGPPIdentitySelectPlatformWidget = {}

---@param InLoginType EGPPlatformLoginType
function UGPPIdentitySelectPlatformWidget:OnSelectPlatformComplete(InLoginType) end
---@param pKID boolean
---@param pGoogle boolean
---@param pFacebook boolean
---@param pApple boolean
---@param pDiscord boolean
---@param pGuest boolean
---@param pLastLogin EGPPlatformLoginType
function UGPPIdentitySelectPlatformWidget:GPPShowSelectPlatformWidgetBP(pKID, pGoogle, pFacebook, pApple, pDiscord, pGuest, pLastLogin) end
---@param pLoginType FString
---@return boolean
function UGPPIdentitySelectPlatformWidget:GPPLogin(pLoginType) end


---@class UGPPKeyGuideFooterWidget : UUserWidget
---@field LeftKeyGuideInfoList TArray<FGPPKeyGuideInfo>
---@field RightKeyGuideInfoList TArray<FGPPKeyGuideInfo>
---@field StickYGuideWidget TSubclassOf<UGPPKeyGuideWidget>
---@field ButtonGuideWidget TSubclassOf<UGPPKeyGuideWidget>
---@field KeyGuidePadding float
---@field KeyGuideInputInfoList TArray<FGPPKeyGuideInputInfo>
---@field HB_KeyGuide UHorizontalBox
local UGPPKeyGuideFooterWidget = {}



---@class UGPPKeyGuideWidget : UUserWidget
---@field Img_Key UImage
---@field T_GuideText UTextBlock
---@field KeyImageInfo TSubclassOf<UGPPKeyImageInfo>
local UGPPKeyGuideWidget = {}



---@class UGPPKeyImageInfo : UObject
---@field KeyImageList TMap<FKey, FGPPKeyImages>
local UGPPKeyImageInfo = {}



---@class UGPPLegalAgreementButtonConsoleWidget : UUserWidget
---@field Img_Background UImage
---@field T_ButtonText UTextBlock
---@field NormalColor FSlateColor
---@field FocusedColor FSlateColor
---@field DisabledColor FSlateColor
---@field bEnabled boolean
---@field bFocused boolean
---@field ButtonText FText
local UGPPLegalAgreementButtonConsoleWidget = {}



---@class UGPPLegalAgreementConsoleWidget : UUserWidget
---@field LegalAgreementWidgetObject UGPPLegalAgreementWidgetObject
---@field SB_LegalAgreementListScroll UScrollBox
---@field VB_LegalAgreementListItems UVerticalBox
---@field W_StartButton UGPPLegalAgreementButtonConsoleWidget
---@field W_KeyGuide UGPPKeyGuideFooterWidget
---@field InputController TSubclassOf<UGPPWidgetInputController>
---@field LegalAgreementListItemWidget TSoftClassPtr<UGPPLegalAgreementListItemConsoleWidget>
local UGPPLegalAgreementConsoleWidget = {}



---@class UGPPLegalAgreementListItemConsoleWidget : UUserWidget
---@field Img_Background UImage
---@field Img_CheckBox UImage
---@field RT_LegalText URichTextBlock
---@field NormalColor FSlateColor
---@field FocusedColor FSlateColor
---@field BlankImage FSlateBrush
---@field ChecktImage FSlateBrush
---@field bFocused boolean
---@field bChecked boolean
local UGPPLegalAgreementListItemConsoleWidget = {}



---@class UGPPLegalAgreementListItemMobileWidget : UGPPLegalAgreementListItemWidget
---@field Img_OpenDetailLegalAgreement UWidget
---@field T_AgreementName UTextBlock
---@field Btn_Agree2 UGPPMenuBtnWidget
local UGPPLegalAgreementListItemMobileWidget = {}

---@param Selected boolean
function UGPPLegalAgreementListItemMobileWidget:OnClick_Btn_Agree2(Selected) end


---@class UGPPLegalAgreementListItemPCWidget : UGPPLegalAgreementListItemWidget
---@field Btn_AgreeBox UGPPMenuBtnWidget
---@field RichTextBlock_Title URichTextBlock
local UGPPLegalAgreementListItemPCWidget = {}

---@param Selected boolean
function UGPPLegalAgreementListItemPCWidget:OnClick_Btn_AgreeBox(Selected) end


---@class UGPPLegalAgreementListItemWidget : UGPPBaseScreen
---@field LegalAgreementWidgetObject UGPPLegalAgreementWidgetObject
---@field Btn_Agree UGPPMenuBtnWidget
---@field Btn_OpenDetailLegalAgreement UGPPMenuBtnWidget
local UGPPLegalAgreementListItemWidget = {}

---@param Selected boolean
function UGPPLegalAgreementListItemWidget:OnClick_Btn_OpenDetailLegalAgreement(Selected) end
---@param Selected boolean
function UGPPLegalAgreementListItemWidget:OnClick_Btn_Agree(Selected) end


---@class UGPPLegalAgreementMobileWidget : UGPPLegalAgreementWidget
---@field Btn_AgreeAllAndStart UGPPMenuBtnWidget
---@field Btn_LoginWithOtherAccount UButton
local UGPPLegalAgreementMobileWidget = {}

function UGPPLegalAgreementMobileWidget:OnClick_Btn_LoginWithOtherAccount() end
---@param Selected boolean
function UGPPLegalAgreementMobileWidget:OnClick_Btn_AgreeAllAndStart(Selected) end


---@class UGPPLegalAgreementPCWidget : UGPPLegalAgreementWidget
---@field Btn_AgreeAllAndStart UGPPMenuBtnWidget
---@field Btn_AgreeAll UGPPMenuBtnWidget
---@field Btn_AgreeAllBox UGPPMenuBtnWidget
local UGPPLegalAgreementPCWidget = {}

---@param Selected boolean
function UGPPLegalAgreementPCWidget:OnClick_Btn_AgreeAllBox(Selected) end
---@param Selected boolean
function UGPPLegalAgreementPCWidget:OnClick_Btn_AgreeAllAndStart(Selected) end
---@param Selected boolean
function UGPPLegalAgreementPCWidget:OnClick_Btn_AgreeAll(Selected) end


---@class UGPPLegalAgreementWidget : UGPPBaseScreen
---@field LegalAgreementWidgetObject UGPPLegalAgreementWidgetObject
---@field SB_Content UScrollBox
---@field Btn_Start UGPPMenuBtnWidget
---@field VB_List UVerticalBox
---@field LegalAgreementListItemWidget TSoftClassPtr<UGPPLegalAgreementListItemWidget>
local UGPPLegalAgreementWidget = {}

---@param Selected boolean
function UGPPLegalAgreementWidget:OnClick_Btn_Start(Selected) end
function UGPPLegalAgreementWidget:OnAgreeLegalAgreement() end


---@class UGPPLegalAgreementWidgetObject : UGPPWidgetObject
local UGPPLegalAgreementWidgetObject = {}


---@class UGPPLinkKIDByGPGSWidget : UGPPBaseScreen
---@field TextBlock_Email UTextBlock
---@field Button_Cancel UGPPMenuBtnWidget
---@field Button_Confirm UGPPMenuBtnWidget
---@field LinkKIDByGPGSWidgetObject UGPPLinkKIDByGPGSWidgetObject
local UGPPLinkKIDByGPGSWidget = {}

---@param bEnable boolean
function UGPPLinkKIDByGPGSWidget:OnClickButton_Confirm(bEnable) end
---@param bEnable boolean
function UGPPLinkKIDByGPGSWidget:OnClickButton_Cancel(bEnable) end


---@class UGPPLinkKIDByGPGSWidgetObject : UGPPWidgetObject
local UGPPLinkKIDByGPGSWidgetObject = {}


---@class UGPPLinkKIDByPlatformTokenWidget : UGPPBaseScreen
---@field TextBlock_Description UTextBlock
---@field TextBlock_Email UTextBlock
---@field Button_Confirm UGPPMenuBtnWidget
local UGPPLinkKIDByPlatformTokenWidget = {}

---@param bEnable boolean
function UGPPLinkKIDByPlatformTokenWidget:OnClickButton_Confirm(bEnable) end


---@class UGPPMaintenanceConsoleWidget : UUserWidget
---@field T_Title UTextBlock
---@field T_Duration UTextBlock
---@field T_Desc UTextBlock
---@field SB_Desc USizeBox
---@field SB_ScrollBox UScrollBox
---@field W_KeyGuide UGPPKeyGuideFooterWidget
---@field MaintenanceWidgetObject UGPPMaintenanceWidgetObject
---@field InputController TSubclassOf<UGPPWidgetInputController>
local UGPPMaintenanceConsoleWidget = {}

---@param bEnable boolean
function UGPPMaintenanceConsoleWidget:OnClickBtn_ShowDetail(bEnable) end
---@param bEnable boolean
function UGPPMaintenanceConsoleWidget:OnClickBtn_CopyDeviceId(bEnable) end
---@param bEnable boolean
function UGPPMaintenanceConsoleWidget:OnClickBtn_Confirm(bEnable) end


---@class UGPPMaintenanceWidget : UGPPBaseScreen
---@field Btn_CopyDeviceId UGPPMenuBtnWidget
---@field T_Title UTextBlock
---@field T_Duration UTextBlock
---@field Btn_ShowDetail UGPPMenuBtnWidget
---@field SizeBox_Desc USizeBox
---@field T_Desc UTextBlock
---@field Btn_Confirm UGPPMenuBtnWidget
---@field SizeBox_ShowDetail USizeBox
---@field MaintenanceWidgetObject UGPPMaintenanceWidgetObject
local UGPPMaintenanceWidget = {}

---@param bEnable boolean
function UGPPMaintenanceWidget:OnClickBtn_ShowDetail(bEnable) end
---@param bEnable boolean
function UGPPMaintenanceWidget:OnClickBtn_CopyDeviceId(bEnable) end
---@param bEnable boolean
function UGPPMaintenanceWidget:OnClickBtn_Confirm(bEnable) end


---@class UGPPMaintenanceWidgetObject : UGPPWidgetObject
local UGPPMaintenanceWidgetObject = {}


---@class UGPPMenuBtnWidget : UGPPBaseBtnWidget
---@field T_Title UTextBlock
---@field Img_Background UImage
---@field Ov_Content UOverlay
---@field SB_BulletImg USizeBox
---@field Img_Bullet UImage
---@field bUseBG boolean
---@field BackgroundList TArray<FGPPBrush>
---@field bUseBulletImg boolean
---@field BulletList TArray<FGPPBrush>
---@field BulletPadding FMargin
---@field BulletSize FVector2D
---@field HorizontalAlignment_Content EHorizontalAlignment
---@field HorizontalAlignment_TitleText EHorizontalAlignment
---@field HorizontalAlignment_Bullet EHorizontalAlignment
---@field bUseText boolean
---@field TitleText FText
---@field TextPadding FMargin
---@field TextTintColorList TArray<FGPPColor>
---@field TextFontList TArray<FGPPFont>
local UGPPMenuBtnWidget = {}



---@class UGPPNinePatchBox : UUserWidget
---@field SizeBox USizeBox
---@field VerticalBox UVerticalBox
---@field HorizontalBoxTop UHorizontalBox
---@field HorizontalBoxCenter UHorizontalBox
---@field HorizontalBoxBottom UHorizontalBox
---@field Image_LeftTop UImage
---@field Image_CenterTop UImage
---@field Image_RightTop UImage
---@field Image_LeftCenter UImage
---@field Image_CenterCenter UImage
---@field Image_RightCenter UImage
---@field Image_LeftBottom UImage
---@field Image_CenterBottom UImage
---@field Image_RightBottom UImage
---@field CornerSize uint32
---@field Texture_LeftTop UTexture2D
---@field Texture_CenterTop UTexture2D
---@field Texture_RightTop UTexture2D
---@field Texture_LeftCenter UTexture2D
---@field Texture_CenterCenter UTexture2D
---@field Texture_RightCenter UTexture2D
---@field Texture_LeftBottom UTexture2D
---@field Texture_CenterBottom UTexture2D
---@field Texture_RightBottom UTexture2D
local UGPPNinePatchBox = {}



---@class UGPPPendingAlertConsoleWidget : UUserWidget
---@field TextBlock_Subtitle UTextBlock
---@field TextBlock_Description UTextBlock
---@field SB_Loading USizeBox
---@field SB_Error USizeBox
---@field SB_ScrollBox UScrollBox
---@field W_KeyGuide UGPPKeyGuideFooterWidget
---@field AlertWidgetObject UGPPPendingAlertWidgetObject
---@field InputController TSubclassOf<UGPPWidgetInputController>
local UGPPPendingAlertConsoleWidget = {}



---@class UGPPPendingAlertWidget : UUserWidget
---@field WidgetSwitcher_ButtonContent UWidgetSwitcher
---@field TextBlock_Title UTextBlock
---@field TextBlock_Subtitle UTextBlock
---@field TextBlock_Description UTextBlock
---@field Button_ForOneButtonClose UGPPMenuBtnWidget
---@field Button_ForTwoButtonLeft UGPPMenuBtnWidget
---@field Button_ForTwoButtonRight UGPPMenuBtnWidget
---@field SizeBox_Error USizeBox
---@field AlertWidgetObject UGPPPendingAlertWidgetObject
local UGPPPendingAlertWidget = {}

---@param bIsSelect boolean
function UGPPPendingAlertWidget:OnClickButton_ForTwoButtonRight(bIsSelect) end
---@param bIsSelect boolean
function UGPPPendingAlertWidget:OnClickButton_ForTwoButtonLeft(bIsSelect) end
---@param bIsSelect boolean
function UGPPPendingAlertWidget:OnClickButton_ForOneButtonClose(bIsSelect) end


---@class UGPPPendingAlertWidgetObject : UGPPWidgetObject
local UGPPPendingAlertWidgetObject = {}


---@class UGPPPendingLoginCompleteConsoleWidget : UUserWidget
---@field WidgetSwitcher_Main UWidgetSwitcher
---@field W_QRCodeURL UAccelByteQrImage
---@field W_AccountCheckerQRCodeURL UAccelByteQrImage
---@field TextBlock_Code UTextBlock
---@field TextBlock_CheckAccountHeader UTextBlock
---@field RT_Header URichTextBlock
---@field RT_Contents URichTextBlock
---@field TextBlock_RemainTime UTextBlock
---@field SB_ScrollBox UScrollBox
---@field SB_ScrollBox_CheckAccount UScrollBox
---@field W_KeyGuide UGPPKeyGuideFooterWidget
---@field W_AccountCheckerKeyGuide UGPPKeyGuideFooterWidget
---@field PendingLoginCompleteWidgetObject UGPPPendingLoginCompleteWidgetObject
---@field InputController TSubclassOf<UGPPWidgetInputController>
local UGPPPendingLoginCompleteConsoleWidget = {}



---@class UGPPPendingLoginCompleteWidget : UUserWidget
---@field W_QRCodeURL UAccelByteQrImage
---@field TextBlock_Code UTextBlock
---@field W_AccountCheckerQRCodeURL UAccelByteQrImage
---@field RT_Header URichTextBlock
---@field TextBlock_CheckAccountHeader UTextBlock
---@field RT_Contents URichTextBlock
---@field TextBlock_RemainTime UTextBlock
---@field Button_HyperLink UButton
---@field Button_AccountChecker UGPPMenuBtnWidget
---@field TextBlock_HyperLink UTextBlock
---@field Button_Close UGPPMenuBtnWidget
---@field Button_Connect UGPPMenuBtnWidget
---@field WidgetSwitcher_Main UWidgetSwitcher
---@field Button_Cancel UGPPMenuBtnWidget
---@field Button_HeadlessCheckEligibilityClose UButton
---@field Button_HeadlessCheckEligibility UGPPMenuBtnWidget
---@field W_HeadlessCheckEligibilityQRCodeURL UAccelByteQrImage
---@field TextBlock_HeadlessCheckEligibilityTitle UTextBlock
---@field TextBlock_HeadlessCheckEligibilityContent UTextBlock
---@field TextBlock_HeadlessCheckEligibilityWarning UTextBlock
---@field TextBlock_HeadlessCheckEligibilityAlert UTextBlock
---@field PendingLoginCompleteWidgetObject UGPPPendingLoginCompleteWidgetObject
local UGPPPendingLoginCompleteWidget = {}

function UGPPPendingLoginCompleteWidget:OnClickButton_HyperLink() end
function UGPPPendingLoginCompleteWidget:OnClickButton_HeadlessCheckEligibilityClose() end
---@param bIsSelected boolean
function UGPPPendingLoginCompleteWidget:OnClickButton_HeadlessCheckEligibilityChecker(bIsSelected) end
---@param bIsSelected boolean
function UGPPPendingLoginCompleteWidget:OnClickButton_ConnectHandle(bIsSelected) end
---@param bIsSelected boolean
function UGPPPendingLoginCompleteWidget:OnClickButton_Close(bIsSelected) end
---@param bIsSelected boolean
function UGPPPendingLoginCompleteWidget:OnClickButton_Cancel(bIsSelected) end
---@param bIsSelected boolean
function UGPPPendingLoginCompleteWidget:OnClickButton_AccountChecker(bIsSelected) end


---@class UGPPPendingLoginCompleteWidgetObject : UGPPWidgetObject
local UGPPPendingLoginCompleteWidgetObject = {}


---@class UGPPPlatformLoginTypeBtnWidget : UGPPBaseScreen
---@field Img UImage
---@field Btn UGPPMenuBtnWidget
---@field Btn_Recommended UGPPMenuBtnWidget
---@field RecentLoginIndicator UWidget
---@field LoginTypeInfoList TArray<FGPPPlatformLoginTypeInfo>
local UGPPPlatformLoginTypeBtnWidget = {}

---@param LoginType EGPPlatformLoginType
function UGPPPlatformLoginTypeBtnWidget:OnClickedPlatformLoginTypeBtn__DelegateSignature(LoginType) end
---@param bSelected boolean
function UGPPPlatformLoginTypeBtnWidget:OnClickBtn(bSelected) end


---@class UGPPPlatformLoginWidget : UGPPBaseScreen
---@field UniformGridPanel_Main UUniformGridPanel
---@field Btn_CopyDeviceId UGPPMenuBtnWidget
---@field LandscapeColumnCount int32
---@field DefaultColumnCount int32
---@field Btn_Close UGPPMenuBtnWidget
---@field PlatformLoginTypeBtn TSoftClassPtr<UGPPPlatformLoginTypeBtnWidget>
---@field PlatformLoginWidgetObject UGPPPlatformLoginWidgetObject
local UGPPPlatformLoginWidget = {}

---@param LoginType EGPPlatformLoginType
function UGPPPlatformLoginWidget:OnClickBtn_PlatformButton(LoginType) end
---@param bEnable boolean
function UGPPPlatformLoginWidget:OnClickBtn_CopyDeviceId(bEnable) end
---@param bEnable boolean
function UGPPPlatformLoginWidget:OnClickBtn_Close(bEnable) end


---@class UGPPPlatformLoginWidgetObject : UGPPWidgetObject
local UGPPPlatformLoginWidgetObject = {}


---@class UGPPPurchaseLimitButtonItemWidget : UGPPBaseScreen
---@field HorizontalAlignment EHorizontalAlignment
---@field VerticalAlignment EVerticalAlignment
---@field Btn_Select UGPPMenuBtnWidget
local UGPPPurchaseLimitButtonItemWidget = {}

---@param bInSelected boolean
function UGPPPurchaseLimitButtonItemWidget:OnClickBtnSelect(bInSelected) end


---@class UGPPPurchaseLimitRadioButtonItemWidget : UGPPBaseScreen
---@field Btn_Select UGPPMenuBtnWidget
local UGPPPurchaseLimitRadioButtonItemWidget = {}

---@param bInSelected boolean
function UGPPPurchaseLimitRadioButtonItemWidget:OnClickBtnSelect(bInSelected) end


---@class UGPPPurchaseLimitWidget : UGPPBaseScreen
---@field ButtonWidgetList TArray<UGPPPurchaseLimitButtonItemWidget>
---@field T_Title UTextBlock
---@field T_Description UTextBlock
---@field VB_RadioButtonList UVerticalBox
---@field GP_ButtonList UUniformGridPanel
---@field PurchaseLimitRadioButtonItemWidget TSoftClassPtr<UGPPPurchaseLimitRadioButtonItemWidget>
---@field PurchaseLimitPrimaryButtonItemWidget TSoftClassPtr<UGPPPurchaseLimitButtonItemWidget>
---@field PurchaseLimitNormalButtonItemWidget TSoftClassPtr<UGPPPurchaseLimitButtonItemWidget>
---@field PurchaseLimitWidgetObject UGPPPurchaseLimitWidgetObject
local UGPPPurchaseLimitWidget = {}



---@class UGPPPurchaseLimitWidgetObject : UGPPWidgetObject
local UGPPPurchaseLimitWidgetObject = {}


---@class UGPPRichTextBlockInlineDecorator : URichTextBlockDecorator
local UGPPRichTextBlockInlineDecorator = {}


---@class UGPPToastMessageWidget : UGPPBaseScreen
---@field DestroyWidgetAnim UWidgetAnimation
---@field DestroyFirstDelay float
---@field FastDestroyAnimPlayRate float
---@field SuccessTypeIcon FSlateBrush
---@field ErrorTypeIcon FSlateBrush
---@field WarningTypeIcon FSlateBrush
---@field InfoTypeIcon FSlateBrush
---@field PaddingByUIModeList TArray<FPaddingByUIMode>
---@field VerticalAlign EVerticalAlignment
---@field HorizontalAlign EHorizontalAlignment
---@field TitleText FText
---@field ContentText FText
---@field RootComp UWidget
---@field T_Title UTextBlock
---@field RootContent UWidget
---@field T_Content UTextBlock
---@field Img_TitleBulletIcon UImage
---@field Btn_Close UGPPMenuBtnWidget
---@field ToastMessageWidgetObject UGPPToastMessageWidgetObject
local UGPPToastMessageWidget = {}

function UGPPToastMessageWidget:OnCloseWidget() end
---@param bEnable boolean
function UGPPToastMessageWidget:OnClickBtn_Close(bEnable) end
function UGPPToastMessageWidget:DestroyToastMessageWidget() end


---@class UGPPToastMessageWidgetObject : UGPPWidgetObject
local UGPPToastMessageWidgetObject = {}


---@class UGPPUISettings : UObject
---@field BaseZOrder int32
---@field ToastMessageWidget TSoftClassPtr<UUserWidget>
---@field ToastMessagePCWidget TSoftClassPtr<UUserWidget>
---@field AlertWidget TSoftClassPtr<UUserWidget>
---@field PlatformLoginWidget TSoftClassPtr<UUserWidget>
---@field LegalAgreementPCWidget TSoftClassPtr<UUserWidget>
---@field LegalAgreementWidget TSoftClassPtr<UUserWidget>
---@field LegalAgreementMobileWidget TSoftClassPtr<UUserWidget>
---@field LegalAgreementConsoleWidget TSoftClassPtr<UUserWidget>
---@field MaintenanceWidget TSoftClassPtr<UUserWidget>
---@field MaintenanceConsoleWidget TSoftClassPtr<UUserWidget>
---@field PendingLoginCompleteWidget TSoftClassPtr<UUserWidget>
---@field PendingLoginCompleteConsoleWidget TSoftClassPtr<UUserWidget>
---@field LinkKIDByGPGSWidget TSoftClassPtr<UUserWidget>
---@field PurchaseLimitWidget TSoftClassPtr<UUserWidget>
---@field PendingAlertWidget TSoftClassPtr<UUserWidget>
---@field PendingAlertConsoleWidget TSoftClassPtr<UUserWidget>
local UGPPUISettings = {}



---@class UGPPWidgetInputCondition : UObject
local UGPPWidgetInputCondition = {}


---@class UGPPWidgetInputCondition_AnalogMove : UGPPWidgetInputCondition
---@field Key FKey
local UGPPWidgetInputCondition_AnalogMove = {}



---@class UGPPWidgetInputCondition_Conditions : UGPPWidgetInputCondition
---@field Operator EGPPWidgetInputCondition_ConditionsOperator
---@field Conditions TArray<UGPPWidgetInputCondition>
local UGPPWidgetInputCondition_Conditions = {}



---@class UGPPWidgetInputCondition_KeyDown : UGPPWidgetInputCondition
---@field Key FKey
local UGPPWidgetInputCondition_KeyDown = {}



---@class UGPPWidgetInputCondition_NavigationAction : UGPPWidgetInputCondition
---@field UINavigationAction EUINavigationAction
local UGPPWidgetInputCondition_NavigationAction = {}



---@class UGPPWidgetInputCondition_WithEditor : UGPPWidgetInputCondition
local UGPPWidgetInputCondition_WithEditor = {}


---@class UGPPWidgetInputController : UObject
---@field ConditionExecList TArray<FGPPWidgetInputConditionExec>
local UGPPWidgetInputController = {}



---@class UGPPWidgetInputExecInfo : UObject
local UGPPWidgetInputExecInfo = {}


---@class UGPPWidgetInputExecInfo_AcceptAllAndStart : UGPPWidgetInputExecInfo
local UGPPWidgetInputExecInfo_AcceptAllAndStart = {}


---@class UGPPWidgetInputExecInfo_Cancel : UGPPWidgetInputExecInfo
local UGPPWidgetInputExecInfo_Cancel = {}


---@class UGPPWidgetInputExecInfo_Close : UGPPWidgetInputExecInfo
local UGPPWidgetInputExecInfo_Close = {}


---@class UGPPWidgetInputExecInfo_OpenDetail : UGPPWidgetInputExecInfo
local UGPPWidgetInputExecInfo_OpenDetail = {}


---@class UGPPWidgetInputExecInfo_OpenWebBrowser : UGPPWidgetInputExecInfo
local UGPPWidgetInputExecInfo_OpenWebBrowser = {}


---@class UGPPWidgetInputExecInfo_ScrollMove : UGPPWidgetInputExecInfo
---@field ScrollSpeed float
local UGPPWidgetInputExecInfo_ScrollMove = {}



---@class UGPPWidgetInputExecInfo_Select : UGPPWidgetInputExecInfo
local UGPPWidgetInputExecInfo_Select = {}


---@class UGPPWidgetInputExecInfo_Start : UGPPWidgetInputExecInfo
local UGPPWidgetInputExecInfo_Start = {}


---@class UGPPWidgetObject : UObject
local UGPPWidgetObject = {}


---@class UGPPWidgetSwitcher : UWidgetSwitcher
local UGPPWidgetSwitcher = {}


---@class URecentLoginPlatform : USaveGame
---@field RecentLoginPlatform FString
local URecentLoginPlatform = {}



